﻿using System.Collections;
using System.Collections.Generic;
using TMPro;
using UnityEngine;
using UnityEngine.UI;

public class CountdownController : MonoBehaviour
{

    private int countdownTime;
    [SerializeField]
    private TMP_Text countdownDisplay;
    [SerializeField]
    private Manager _manager;

    private void Start()
    {
        countdownTime = 3;
        countdownDisplay.gameObject.SetActive(true);
        StartCoroutine(CountdownToStart());    
    }

    IEnumerator CountdownToStart()
    {
        while (countdownTime > 0)
        {
            countdownDisplay.text = countdownTime.ToString();

            yield return new WaitForSeconds(1f);

            countdownTime--;
        }

        countdownDisplay.text = "GO";

        _manager.BeginGame();

        yield return new WaitForSeconds(0.5f);

        countdownDisplay.gameObject.SetActive(false);
    }
}
